ORCA/M Asm65816 2.1.0

0001 C300                       TITLE '$C3xx Internal ROM Code'
0002 C300
0003 C300              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0004 C300              ;	by EdAsmCvtIIGS version 1.2d5 on 5/9/91 at 9:27:10 PM
0005 C300
0006 C300              *********************************************
0007 C300              *                                           *
0008 C300              *          Apple //e Video Firmware         *
0009 C300              *                                           *
0010 C300              *         R. Auricchio      Aug 1981        *       
0011 C300              *         E. Beernink           1984        *
0012 C300              *         F. Bachman         1985-1987      *
0013 C300              *                                           *
0014 C300              *       Copyright Apple Computer, Inc.      *
0015 C300              *                  1981-1987                *
0016 C300              *            All Rights Reserved            *
0017 C300              *                                           *
0018 C300              *********************************************
0019 C300
0020 C300              **************************************************************
0021 C300              *                                                            *
0022 C300              * THIS IS THE $C3XX ROM SPACE:                               *
0023 C300              * Note:  This page must not be used by any routines          *
0024 C300              * called by the F8 ROM.  When it is referenced, it claims    *
0025 C300              * the C800 space (kicking out anyone who was using it).      *
0026 C300              * This also means that peripheral cards cannot use the       *
0027 C300              * AUXMOVE and XFER routines from their C800 space.           *
0028 C300              *                                                            *
0029 C300              **************************************************************
0030 C300
0031 C300              C300     EQU   *                        ;Maintained entry point $C300
0032 C300 E2 40                 SEP   #$40                     ;set vflag (init) 
0033 C302 70 37                 BVS   BASICENT                 ;(ALWAYS TAKEN)
0034 C304 EA                    NOP                            ;A filler is required here
0035 C305
0036 C305              * BASIC input entry point.  After a PR#3, this is the 
0037 C305              * address that is called to input each character.
0038 C305
0039 C305              BASICIN  EQU   *                        ;Maintained entry point $C305
0040 C305 38                    SEC   
0041 C306 90                    OPCODE BCC                     ;(NEVER TAKEN)
0042 C307
0043 C307              * BASIC output entry point.  After a PR#3, this is the
0044 C307              * address that is called to output each character.
0045 C307
0046 C307              BASICOUT EQU   *                        ;Maintained entry point $C307
0047 C307 18                    CLC   
0048 C308 B8                    CLV                            ;CLEAR VFLAG (NOT INIT)
0049 C309 50 30                 BVC   BASICENT                 ;(ALWAYS TAKEN) 
0050 C30B
0051 C30B              * Pascal 1.1 Firmware Protocol table:
0052 C30B
0053 C30B              * This tables identifies this as an Apple //e 80 column
0054 C30B              * card.  It points to the four routines available to 
0055 C30B              * programs doing I/O using the Pascal 1.1 Firmware 
0056 C30B              * Protocol.
0057 C30B
0058 C30B              * The next 6 entry points are maintained entry points
0059 C30B 01                    DC B:$01                       ;GENERIC SIGNATURE BYTE
0060 C30C 88                    DC B:$88                       ;DEVICE SIGNATURE BYTE
0061 C30D
0062 C30D 69                    DC B:JPINIT                    ;PASCAL INIT
0063 C30E 6F                    DC B:JPREAD                    ;PASCAL READ
0064 C30F 75                    DC B:JPWRITE                   ;PASCAL WRITE
0065 C310 7B                    DC B:JPSTAT                    ;PASCAL STATUS
0066 C311
0067 C311              * 128K SUPPORT ROUTINE ENTRIES:
0068 C311
0069 C311              * Maintained entry point $C311
0070 C311 4C 98 C3              JMP   MOVEC                    ;MEMORY MOVE ACROSS BANKS 
0071 C314              * Maintained entry point $C314
0072 C314
0073 C314              ****************************************
0074 C314              * NAME    : XFER
0075 C314              * FUNCTION: TRANSFER CONTROL CROSSBANK
0076 C314              * INPUT   : $03ED=TRANSFER ADDR
0077 C314              *         : CARRY SET=XFER TO CARD
0078 C314              *                 CLR=XFER TO MAIN
0079 C314              *         : VFLAG CLR=USE STD ZP/STK
0080 C314              *         :       SET=USE ALT ZP/STK
0081 C314              * OUTPUT  : NONE
0082 C314              * VOLATILE: $03ED/03EE IN DEST BANK 
0083 C314              * CALLS   : NOTHING
0084 C314              * NOTE    : ENTERED VIA JMP, NOT JSR
0085 C314              ****************************************
0086 C314
0087 C314              XFER     EQU   *
0088 C314 EB                    XBA                            ;Preserve entry 'A'
0089 C315 AD ED 03              LDA   $3ED                     ;What's addr to execute at in other bank
0090 C318 48                    PHA                            ;Save for later
0091 C319 AD EE 03              LDA   $3EE                     ;
0092 C31C 48                    PHA                            ;
0093 C31D A9 30                 LDA   #$30                     ;Arbitrarily set read/write alt RAM
0094 C31F 0C 68 C0              TSB   STATEREG                 ;
0095 C322 B0 03                 BCS   @2                       ;'c'=1 then stay in alternate memory
0096 C324 1C 68 C0              TRB   STATEREG                 ;'c'=0 then set read/write main RAM
0097 C327              @2       EQU   *
0098 C327 68                    PLA                            ;Recall execution address for other bank
0099 C328 8D EE 03              STA   $3EE                     ;
0100 C32B 68                    PLA                            ;
0101 C32C 8D ED 03              STA   $3ED                     ;
0102 C32F EB                    XBA                            ;Restore entry 'A'
0103 C330 8D 08 C0              STA   SETSTDZP                 ;Arbitrarily set std zeropage/lang card
0104 C333 50 03                 BVC   @4                       ;'v'=0 then stay in main zp/lang card
0105 C335 8D 09 C0              STA   SETALTZP                 ; else change to alternate zp/lang card
0106 C338              @4       EQU   *
0107 C338 6C ED 03              JMP   ($3ED)                   ;Go execute code in other bank
0108 C33B
0109 C33B
0110 C33B              ****************************************
0111 C33B
0112 C33B 8D 7B 06     BASICENT STA   CHAR
0113 C33E 5A                    PHY                            ;Save registers
0114 C33F DA                    PHX                            ;
0115 C340 08                    PHP                            ;SAVE CARRY & VFLAG
0116 C341
0117 C341              * If escape mode is allowed, the high bit of MSLOT is 
0118 C341              * clear.  Set M_CTL to flag that 1) escapes are allowed, and
0119 C341              * 2) that control characters should not be echoed.
0120 C341              * M_CTL is cleared by BPRINT.
0121 C341
0122 C341 2C F8 07              BIT   MSLOT                    ;get MSLOT
0123 C344 30 05                 BMI   @1                       ;=>Esc disable, ctl char enable
0124 C346 A9 08                 LDA   #M_CTL
0125 C348 0C FB 04              TSB   MODE
0126 C34B
0127 C34B              @1       EQU   *
0128 C34B 20 8F C3              JSR   SETC8                    ;SETUP C8 INDICATOR
0129 C34E 28                    PLP                            ;GET VFLAG (INIT)
0130 C34F 70 15                 BVS   JBASINIT                 ;=>DO THE INIT
0131 C351
0132 C351              * If a PR#0 has been done, input should be transferred
0133 C351              * from the video firmware to KEYIN.  This is detected
0134 C351              * if the high bit of the mode byte is set.
0135 C351
0136 C351 90 10                 BCC   @2                       ;=>output, no problem
0137 C353 AD FB 04              LDA   MODE                     ;test mode
0138 C356 10 0B                 BPL   @2                       ;video firmware is on
0139 C358 20 F4 CC              JSR   SETKEYIN                 ;else set FD1B as input
0140 C35B FA                    PLX                            ;restore registers
0141 C35C 7A                    PLY   
0142 C35D AD 7B 06              LDA   CHAR
0143 C360 6C 38 00              JMP   (KSWL)                   ;go input the character
0144 C363
0145 C363 4C 5A C8     @2       JMP   C8BASIC                  ;GET OUT OF CN SPACE
0146 C366
0147 C366 4C 03 C8     JBASINIT JMP   BASICINIT                ;=>GOTO C8 SPACE
0148 C369
0149 C369              JPINIT   EQU   *
0150 C369 20 8F C3              JSR   SETC8                    ;SETUP C8 INDICATOR
0151 C36C 4C B4 C9              JMP   PINIT                    ;XFER TO PASCAL INIT
0152 C36F
0153 C36F              JPREAD   EQU   *
0154 C36F 20 8F C3              JSR   SETC8                    ;SETUP C8 INDICATOR
0155 C372 4C D0 C9              JMP   PASCALREAD               ;XFER TO PASCAL READ
0156 C375
0157 C375              JPWRITE  EQU   *
0158 C375 20 8F C3              JSR   SETC8                    ;SETUP C8 INDICATOR
0159 C378 4C EA C9              JMP   PWRITE                   ;XFER TO PASCAL WRITE
0160 C37B
0161 C37B              JPSTAT   EQU   *
0162 C37B 20 8F C3              JSR   SETC8                    ;Setup C8 indicator
0163 C37E AA                    TAX                            ;is request code = 0?
0164 C37F F0 08                 BEQ   @1                       ;=>yes, ready for output
0165 C381 CA                    DEX                            ;check for any input
0166 C382 D0 07                 BNE   PSTERR                   ;=>bad request, return error
0167 C384 20 94 CF              JSR   XBITKBD                  ;look for a key
0168 C387 10 04                 BPL   PNOTRDY                  ;=>no keystroked
0169 C389 38           @1       SEC   
0170 C38A 60                    RTS   
0171 C38B
0172 C38B A2 03        PSTERR   LDX   #3                       ;else flag error
0173 C38D 18           PNOTRDY  CLC   
0174 C38E 60                    RTS   
0175 C38F                       EJECT 
0176 C38F              ****************************************
0177 C38F              * NAME    : SETC8
0178 C38F              * FUNCTION: SETUP IRQ $C800 PROTOCOL
0179 C38F              * INPUT   : NONE
0180 C38F              * OUTPUT  : NONE
0181 C38F              * VOLATILE: NOTHING
0182 C38F              * CALLS   : NOTHING
0183 C38F              ****************************************
0184 C38F
0185 C38F              SETC8    EQU   *
0186 C38F A2 C3                 LDX   #>C300                   ;SLOT NUMBER
0187 C391 8E F8 07              STX   MSLOT                    ;STUFF IT
0188 C394 AE FF CF              LDX   CLRROM                   ;kick out other $C8 ROMs
0189 C397 60                    RTS   
0190 C398
0191 C398              ****************************************
0192 C398              * NAME    : MOVEC
0193 C398              * FUNCTION: PERFORM CROSSBANK MEMORY MOVEC
0194 C398              * INPUT   : A1=SOURCE ADDRESS
0195 C398              *         : A2=SOURCE END
0196 C398              *         : A4=DESTINATION START
0197 C398              *         : CARRY SET=MAIN-->CARD
0198 C398              *                 CLR=CARD-->MAIN
0199 C398              * OUTPUT  : A1=A2+1
0200 C398              *         : A4=A4+(A2-A1)+1
0201 C398              * VOLATILE: NOTHING
0202 C398              * CALLS   : NOTHING
0203 C398              ****************************************
0204 C398
0205 C398              MOVEC    EQU   *
0206 C398 8B                    PHB                            ;Save data bank register before moving
0207 C399 48                    PHA                            ;Save A
0208 C39A 5A                    PHY                            ;Save Y
0209 C39B DA                    PHX                            ;Save X
0210 C39C AD 68 C0              LDA   STATEREG                 ;Save user memory configuration
0211 C39F 48                    PHA                            ;
0212 C3A0 29 CF                 AND   #$CF                     ;Must enable read/write main memory
0213 C3A2 8D 68 C0              STA   STATEREG                 ;
0214 C3A5 AD 36 C0              LDA   CYAREG                   ;Go to hi speed after saving current speed
0215 C3A8 48                    PHA                            ;
0216 C3A9 09 80                 ORA   #$80                     ;Set hi bit
0217 C3AB 8D 36 C0              STA   CYAREG                   ;
0218 C3AE 08                    PHP                            ;Save C for a little while
0219 C3AF 08                    PHP                            ;Save C for a little while
0220 C3B0 18                    CLC                            ;Switch modes
0221 C3B1 FB                    XCE                            ;Off to native land
0222 C3B2 C2 30                 REP   #$30                     ;Off to 16 bit land
0223 C3B4 38                    SEC                            ;Calculate length to move
0224 C3B5 A5 3E                 LDA   A2L                      ;Src ending addr minus src starting addr
0225 C3B7 48                    PHA                            ;Save for later
0226 C3B8 E5 3C                 SBC   A1L                      ; leaves source data length in 'A'
0227 C3BA 48                    PHA                            ;Save length of move for later
0228 C3BB A3 05                 LDA   5,S                      ;Get back 'c'
0229 C3BD 6A                    ROR   A                        ;Set carry as it was before
0230 C3BE A3 01                 LDA   1,S                      ;Get subtraction result back
0231 C3C0 A6 3C                 LDX   A1L                      ;Source address
0232 C3C2 A4 42                 LDY   A4L                      ;Destination address
0233 C3C4 90 05                 BCC   @1                       ;C=0 then aux to main
0234 C3C6 54 01 00              MVN   $000000,$010000          ;Move bank 00 data to bank 01
0235 C3C9 80 03                 BRA   @2                       ;
0236 C3CB
0237 C3CB              @1       EQU   *
0238 C3CB 54 00 01              MVN   $010000,$000000          ;Move bank 01 to bank 00
0239 C3CE              @2       EQU   *
0240 C3CE 68                    PLA                            ;Fix A4 for those who need A4=A4+(A2-A1)+1
0241 C3CF 38                    SEC                            ;Cause +1 to be added
0242 C3D0 65 42                 ADC   A4L                      ;
0243 C3D2 85 42                 STA   A4L                      ;A4=(A2-A1)+1
0244 C3D4 68                    PLA                            ;Fix A1 for those who need on A1=A2+1
0245 C3D5 1A                    INC   A                        ;+1
0246 C3D6 85 3C                 STA   A1L                      ;A1=A2+1
0247 C3D8 68                    PLA                            ;Clean entry status off stack
0248 C3D9 E2 30                 SEP   #$30                     ;PUT SEC/XCE BELOW HERE WHEN MEGA// FIXED
0249 C3DB 68                    PLA                            ;Restore system speed
0250 C3DC 8D 36 C0              STA   CYAREG                   ;
0251 C3DF 68                    PLA                            ;Restore user memory configuration
0252 C3E0 8D 68 C0              STA   STATEREG                 ;
0253 C3E3 38                    SEC                            ;Back to emulation mode to exit
0254 C3E4 FB                    XCE                            ;
0255 C3E5 FA                    PLX                            ;Restore X
0256 C3E6 7A                    PLY                            ;Restore Y
0257 C3E7 68                    PLA                            ;Restore A
0258 C3E8 AB                    PLB                            ;MUST restore data bank reg after moving
0259 C3E9 60                    RTS                            ;Back to caller
0260 C3EA
0261 C3EA              FIXCURSHIFTER EQU   *                   ;Reset CURSHIFTER
0262 C3EA AF EE 02 E1           LDA   >USERFLASH               ;
0263 C3EE 49 07                 EOR   #$07                     ;Flip lower 3 bits
0264 C3F0 38                    SEC                            ;Subtract 3
0265 C3F1 E9 03                 SBC   #$03                     ;
0266 C3F3 0A                    ASL   A                        ;Now times 2
0267 C3F4 1A                    INC   A                        ;Now add 1
0268 C3F5 8F 45 01 E1           STA   >CURSHIFTER              ;Save for later
0269 C3F9 60                    RTS                            ;Back to caller
0270 C3FA
0271 C3FA
0272 C3FA                                                      ; SEG $FF
0273 C3FA              ESCIN    EQU   *
0274 C3FA 88 95 8A 8B           DC B:$88,$95,$8A,$8B,$86,$82
0275 C400                                                      ; SEG $00
0276 C400
0277 C400
